// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookFormatProtection;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Format Protection Request.
 */
public interface IWorkbookFormatProtectionRequest extends IHttpRequest {

    /**
     * Gets the WorkbookFormatProtection from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super WorkbookFormatProtection> callback);

    /**
     * Gets the WorkbookFormatProtection from the service
     *
     * @return the WorkbookFormatProtection from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookFormatProtection get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super WorkbookFormatProtection> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookFormatProtection with a source
     *
     * @param sourceWorkbookFormatProtection the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookFormatProtection sourceWorkbookFormatProtection, final ICallback<? super WorkbookFormatProtection> callback);

    /**
     * Patches this WorkbookFormatProtection with a source
     *
     * @param sourceWorkbookFormatProtection the source object with updates
     * @return the updated WorkbookFormatProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookFormatProtection patch(final WorkbookFormatProtection sourceWorkbookFormatProtection) throws ClientException;

    /**
     * Posts a WorkbookFormatProtection with a new object
     *
     * @param newWorkbookFormatProtection the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookFormatProtection newWorkbookFormatProtection, final ICallback<? super WorkbookFormatProtection> callback);

    /**
     * Posts a WorkbookFormatProtection with a new object
     *
     * @param newWorkbookFormatProtection the new object to create
     * @return the created WorkbookFormatProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookFormatProtection post(final WorkbookFormatProtection newWorkbookFormatProtection) throws ClientException;

    /**
     * Posts a WorkbookFormatProtection with a new object
     *
     * @param newWorkbookFormatProtection the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookFormatProtection newWorkbookFormatProtection, final ICallback<? super WorkbookFormatProtection> callback);

    /**
     * Posts a WorkbookFormatProtection with a new object
     *
     * @param newWorkbookFormatProtection the object to create/update
     * @return the created WorkbookFormatProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookFormatProtection put(final WorkbookFormatProtection newWorkbookFormatProtection) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookFormatProtectionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookFormatProtectionRequest expand(final String value);

}

