// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartAxisFormat;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Axis Format Request.
 */
public interface IWorkbookChartAxisFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartAxisFormat from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super WorkbookChartAxisFormat> callback);

    /**
     * Gets the WorkbookChartAxisFormat from the service
     *
     * @return the WorkbookChartAxisFormat from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxisFormat get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super WorkbookChartAxisFormat> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartAxisFormat with a source
     *
     * @param sourceWorkbookChartAxisFormat the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookChartAxisFormat sourceWorkbookChartAxisFormat, final ICallback<? super WorkbookChartAxisFormat> callback);

    /**
     * Patches this WorkbookChartAxisFormat with a source
     *
     * @param sourceWorkbookChartAxisFormat the source object with updates
     * @return the updated WorkbookChartAxisFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxisFormat patch(final WorkbookChartAxisFormat sourceWorkbookChartAxisFormat) throws ClientException;

    /**
     * Posts a WorkbookChartAxisFormat with a new object
     *
     * @param newWorkbookChartAxisFormat the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookChartAxisFormat newWorkbookChartAxisFormat, final ICallback<? super WorkbookChartAxisFormat> callback);

    /**
     * Posts a WorkbookChartAxisFormat with a new object
     *
     * @param newWorkbookChartAxisFormat the new object to create
     * @return the created WorkbookChartAxisFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxisFormat post(final WorkbookChartAxisFormat newWorkbookChartAxisFormat) throws ClientException;

    /**
     * Posts a WorkbookChartAxisFormat with a new object
     *
     * @param newWorkbookChartAxisFormat the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookChartAxisFormat newWorkbookChartAxisFormat, final ICallback<? super WorkbookChartAxisFormat> callback);

    /**
     * Posts a WorkbookChartAxisFormat with a new object
     *
     * @param newWorkbookChartAxisFormat the object to create/update
     * @return the created WorkbookChartAxisFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxisFormat put(final WorkbookChartAxisFormat newWorkbookChartAxisFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookChartAxisFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookChartAxisFormatRequest expand(final String value);

}

