// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.UsedInsight;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Used Insight Request.
 */
public interface IUsedInsightRequest extends IHttpRequest {

    /**
     * Gets the UsedInsight from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super UsedInsight> callback);

    /**
     * Gets the UsedInsight from the service
     *
     * @return the UsedInsight from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UsedInsight get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super UsedInsight> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this UsedInsight with a source
     *
     * @param sourceUsedInsight the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final UsedInsight sourceUsedInsight, final ICallback<? super UsedInsight> callback);

    /**
     * Patches this UsedInsight with a source
     *
     * @param sourceUsedInsight the source object with updates
     * @return the updated UsedInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UsedInsight patch(final UsedInsight sourceUsedInsight) throws ClientException;

    /**
     * Posts a UsedInsight with a new object
     *
     * @param newUsedInsight the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final UsedInsight newUsedInsight, final ICallback<? super UsedInsight> callback);

    /**
     * Posts a UsedInsight with a new object
     *
     * @param newUsedInsight the new object to create
     * @return the created UsedInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UsedInsight post(final UsedInsight newUsedInsight) throws ClientException;

    /**
     * Posts a UsedInsight with a new object
     *
     * @param newUsedInsight the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final UsedInsight newUsedInsight, final ICallback<? super UsedInsight> callback);

    /**
     * Posts a UsedInsight with a new object
     *
     * @param newUsedInsight the object to create/update
     * @return the created UsedInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UsedInsight put(final UsedInsight newUsedInsight) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IUsedInsightRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IUsedInsightRequest expand(final String value);

}

