// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ThreatAssessmentResult;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Threat Assessment Result Request.
 */
public interface IThreatAssessmentResultRequest extends IHttpRequest {

    /**
     * Gets the ThreatAssessmentResult from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ThreatAssessmentResult> callback);

    /**
     * Gets the ThreatAssessmentResult from the service
     *
     * @return the ThreatAssessmentResult from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ThreatAssessmentResult get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ThreatAssessmentResult> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ThreatAssessmentResult with a source
     *
     * @param sourceThreatAssessmentResult the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ThreatAssessmentResult sourceThreatAssessmentResult, final ICallback<? super ThreatAssessmentResult> callback);

    /**
     * Patches this ThreatAssessmentResult with a source
     *
     * @param sourceThreatAssessmentResult the source object with updates
     * @return the updated ThreatAssessmentResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ThreatAssessmentResult patch(final ThreatAssessmentResult sourceThreatAssessmentResult) throws ClientException;

    /**
     * Posts a ThreatAssessmentResult with a new object
     *
     * @param newThreatAssessmentResult the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ThreatAssessmentResult newThreatAssessmentResult, final ICallback<? super ThreatAssessmentResult> callback);

    /**
     * Posts a ThreatAssessmentResult with a new object
     *
     * @param newThreatAssessmentResult the new object to create
     * @return the created ThreatAssessmentResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ThreatAssessmentResult post(final ThreatAssessmentResult newThreatAssessmentResult) throws ClientException;

    /**
     * Posts a ThreatAssessmentResult with a new object
     *
     * @param newThreatAssessmentResult the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ThreatAssessmentResult newThreatAssessmentResult, final ICallback<? super ThreatAssessmentResult> callback);

    /**
     * Posts a ThreatAssessmentResult with a new object
     *
     * @param newThreatAssessmentResult the object to create/update
     * @return the created ThreatAssessmentResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ThreatAssessmentResult put(final ThreatAssessmentResult newThreatAssessmentResult) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IThreatAssessmentResultRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IThreatAssessmentResultRequest expand(final String value);

}

