// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.TeamsTab;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Teams Tab Request.
 */
public interface ITeamsTabRequest extends IHttpRequest {

    /**
     * Gets the TeamsTab from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super TeamsTab> callback);

    /**
     * Gets the TeamsTab from the service
     *
     * @return the TeamsTab from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamsTab get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super TeamsTab> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this TeamsTab with a source
     *
     * @param sourceTeamsTab the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final TeamsTab sourceTeamsTab, final ICallback<? super TeamsTab> callback);

    /**
     * Patches this TeamsTab with a source
     *
     * @param sourceTeamsTab the source object with updates
     * @return the updated TeamsTab
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamsTab patch(final TeamsTab sourceTeamsTab) throws ClientException;

    /**
     * Posts a TeamsTab with a new object
     *
     * @param newTeamsTab the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final TeamsTab newTeamsTab, final ICallback<? super TeamsTab> callback);

    /**
     * Posts a TeamsTab with a new object
     *
     * @param newTeamsTab the new object to create
     * @return the created TeamsTab
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamsTab post(final TeamsTab newTeamsTab) throws ClientException;

    /**
     * Posts a TeamsTab with a new object
     *
     * @param newTeamsTab the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final TeamsTab newTeamsTab, final ICallback<? super TeamsTab> callback);

    /**
     * Posts a TeamsTab with a new object
     *
     * @param newTeamsTab the object to create/update
     * @return the created TeamsTab
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamsTab put(final TeamsTab newTeamsTab) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITeamsTabRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITeamsTabRequest expand(final String value);

}

