// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.SharedInsight;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Shared Insight Request.
 */
public interface ISharedInsightRequest extends IHttpRequest {

    /**
     * Gets the SharedInsight from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super SharedInsight> callback);

    /**
     * Gets the SharedInsight from the service
     *
     * @return the SharedInsight from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SharedInsight get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super SharedInsight> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this SharedInsight with a source
     *
     * @param sourceSharedInsight the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final SharedInsight sourceSharedInsight, final ICallback<? super SharedInsight> callback);

    /**
     * Patches this SharedInsight with a source
     *
     * @param sourceSharedInsight the source object with updates
     * @return the updated SharedInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SharedInsight patch(final SharedInsight sourceSharedInsight) throws ClientException;

    /**
     * Posts a SharedInsight with a new object
     *
     * @param newSharedInsight the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final SharedInsight newSharedInsight, final ICallback<? super SharedInsight> callback);

    /**
     * Posts a SharedInsight with a new object
     *
     * @param newSharedInsight the new object to create
     * @return the created SharedInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SharedInsight post(final SharedInsight newSharedInsight) throws ClientException;

    /**
     * Posts a SharedInsight with a new object
     *
     * @param newSharedInsight the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final SharedInsight newSharedInsight, final ICallback<? super SharedInsight> callback);

    /**
     * Posts a SharedInsight with a new object
     *
     * @param newSharedInsight the object to create/update
     * @return the created SharedInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SharedInsight put(final SharedInsight newSharedInsight) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ISharedInsightRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ISharedInsightRequest expand(final String value);

}

