// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Onenote;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Onenote Request.
 */
public interface IOnenoteRequest extends IHttpRequest {

    /**
     * Gets the Onenote from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super Onenote> callback);

    /**
     * Gets the Onenote from the service
     *
     * @return the Onenote from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Onenote get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super Onenote> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Onenote with a source
     *
     * @param sourceOnenote the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Onenote sourceOnenote, final ICallback<? super Onenote> callback);

    /**
     * Patches this Onenote with a source
     *
     * @param sourceOnenote the source object with updates
     * @return the updated Onenote
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Onenote patch(final Onenote sourceOnenote) throws ClientException;

    /**
     * Posts a Onenote with a new object
     *
     * @param newOnenote the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Onenote newOnenote, final ICallback<? super Onenote> callback);

    /**
     * Posts a Onenote with a new object
     *
     * @param newOnenote the new object to create
     * @return the created Onenote
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Onenote post(final Onenote newOnenote) throws ClientException;

    /**
     * Posts a Onenote with a new object
     *
     * @param newOnenote the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Onenote newOnenote, final ICallback<? super Onenote> callback);

    /**
     * Posts a Onenote with a new object
     *
     * @param newOnenote the object to create/update
     * @return the created Onenote
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Onenote put(final Onenote newOnenote) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IOnenoteRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IOnenoteRequest expand(final String value);

}

