// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DomainDnsSrvRecord;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Domain Dns Srv Record Request.
 */
public interface IDomainDnsSrvRecordRequest extends IHttpRequest {

    /**
     * Gets the DomainDnsSrvRecord from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super DomainDnsSrvRecord> callback);

    /**
     * Gets the DomainDnsSrvRecord from the service
     *
     * @return the DomainDnsSrvRecord from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DomainDnsSrvRecord get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super DomainDnsSrvRecord> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DomainDnsSrvRecord with a source
     *
     * @param sourceDomainDnsSrvRecord the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DomainDnsSrvRecord sourceDomainDnsSrvRecord, final ICallback<? super DomainDnsSrvRecord> callback);

    /**
     * Patches this DomainDnsSrvRecord with a source
     *
     * @param sourceDomainDnsSrvRecord the source object with updates
     * @return the updated DomainDnsSrvRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DomainDnsSrvRecord patch(final DomainDnsSrvRecord sourceDomainDnsSrvRecord) throws ClientException;

    /**
     * Posts a DomainDnsSrvRecord with a new object
     *
     * @param newDomainDnsSrvRecord the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DomainDnsSrvRecord newDomainDnsSrvRecord, final ICallback<? super DomainDnsSrvRecord> callback);

    /**
     * Posts a DomainDnsSrvRecord with a new object
     *
     * @param newDomainDnsSrvRecord the new object to create
     * @return the created DomainDnsSrvRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DomainDnsSrvRecord post(final DomainDnsSrvRecord newDomainDnsSrvRecord) throws ClientException;

    /**
     * Posts a DomainDnsSrvRecord with a new object
     *
     * @param newDomainDnsSrvRecord the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DomainDnsSrvRecord newDomainDnsSrvRecord, final ICallback<? super DomainDnsSrvRecord> callback);

    /**
     * Posts a DomainDnsSrvRecord with a new object
     *
     * @param newDomainDnsSrvRecord the object to create/update
     * @return the created DomainDnsSrvRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DomainDnsSrvRecord put(final DomainDnsSrvRecord newDomainDnsSrvRecord) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDomainDnsSrvRecordRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDomainDnsSrvRecordRequest expand(final String value);

}

