// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DeviceConfigurationDeviceStateSummary;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Configuration Device State Summary Request.
 */
public interface IDeviceConfigurationDeviceStateSummaryRequest extends IHttpRequest {

    /**
     * Gets the DeviceConfigurationDeviceStateSummary from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super DeviceConfigurationDeviceStateSummary> callback);

    /**
     * Gets the DeviceConfigurationDeviceStateSummary from the service
     *
     * @return the DeviceConfigurationDeviceStateSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationDeviceStateSummary get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super DeviceConfigurationDeviceStateSummary> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DeviceConfigurationDeviceStateSummary with a source
     *
     * @param sourceDeviceConfigurationDeviceStateSummary the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DeviceConfigurationDeviceStateSummary sourceDeviceConfigurationDeviceStateSummary, final ICallback<? super DeviceConfigurationDeviceStateSummary> callback);

    /**
     * Patches this DeviceConfigurationDeviceStateSummary with a source
     *
     * @param sourceDeviceConfigurationDeviceStateSummary the source object with updates
     * @return the updated DeviceConfigurationDeviceStateSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationDeviceStateSummary patch(final DeviceConfigurationDeviceStateSummary sourceDeviceConfigurationDeviceStateSummary) throws ClientException;

    /**
     * Posts a DeviceConfigurationDeviceStateSummary with a new object
     *
     * @param newDeviceConfigurationDeviceStateSummary the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DeviceConfigurationDeviceStateSummary newDeviceConfigurationDeviceStateSummary, final ICallback<? super DeviceConfigurationDeviceStateSummary> callback);

    /**
     * Posts a DeviceConfigurationDeviceStateSummary with a new object
     *
     * @param newDeviceConfigurationDeviceStateSummary the new object to create
     * @return the created DeviceConfigurationDeviceStateSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationDeviceStateSummary post(final DeviceConfigurationDeviceStateSummary newDeviceConfigurationDeviceStateSummary) throws ClientException;

    /**
     * Posts a DeviceConfigurationDeviceStateSummary with a new object
     *
     * @param newDeviceConfigurationDeviceStateSummary the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DeviceConfigurationDeviceStateSummary newDeviceConfigurationDeviceStateSummary, final ICallback<? super DeviceConfigurationDeviceStateSummary> callback);

    /**
     * Posts a DeviceConfigurationDeviceStateSummary with a new object
     *
     * @param newDeviceConfigurationDeviceStateSummary the object to create/update
     * @return the created DeviceConfigurationDeviceStateSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationDeviceStateSummary put(final DeviceConfigurationDeviceStateSummary newDeviceConfigurationDeviceStateSummary) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDeviceConfigurationDeviceStateSummaryRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDeviceConfigurationDeviceStateSummaryRequest expand(final String value);

}

