// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ActivityBasedTimeoutPolicy;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Activity Based Timeout Policy Request.
 */
public interface IActivityBasedTimeoutPolicyRequest extends IHttpRequest {

    /**
     * Gets the ActivityBasedTimeoutPolicy from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ActivityBasedTimeoutPolicy> callback);

    /**
     * Gets the ActivityBasedTimeoutPolicy from the service
     *
     * @return the ActivityBasedTimeoutPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ActivityBasedTimeoutPolicy get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ActivityBasedTimeoutPolicy> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ActivityBasedTimeoutPolicy with a source
     *
     * @param sourceActivityBasedTimeoutPolicy the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ActivityBasedTimeoutPolicy sourceActivityBasedTimeoutPolicy, final ICallback<? super ActivityBasedTimeoutPolicy> callback);

    /**
     * Patches this ActivityBasedTimeoutPolicy with a source
     *
     * @param sourceActivityBasedTimeoutPolicy the source object with updates
     * @return the updated ActivityBasedTimeoutPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ActivityBasedTimeoutPolicy patch(final ActivityBasedTimeoutPolicy sourceActivityBasedTimeoutPolicy) throws ClientException;

    /**
     * Posts a ActivityBasedTimeoutPolicy with a new object
     *
     * @param newActivityBasedTimeoutPolicy the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ActivityBasedTimeoutPolicy newActivityBasedTimeoutPolicy, final ICallback<? super ActivityBasedTimeoutPolicy> callback);

    /**
     * Posts a ActivityBasedTimeoutPolicy with a new object
     *
     * @param newActivityBasedTimeoutPolicy the new object to create
     * @return the created ActivityBasedTimeoutPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ActivityBasedTimeoutPolicy post(final ActivityBasedTimeoutPolicy newActivityBasedTimeoutPolicy) throws ClientException;

    /**
     * Posts a ActivityBasedTimeoutPolicy with a new object
     *
     * @param newActivityBasedTimeoutPolicy the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ActivityBasedTimeoutPolicy newActivityBasedTimeoutPolicy, final ICallback<? super ActivityBasedTimeoutPolicy> callback);

    /**
     * Posts a ActivityBasedTimeoutPolicy with a new object
     *
     * @param newActivityBasedTimeoutPolicy the object to create/update
     * @return the created ActivityBasedTimeoutPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ActivityBasedTimeoutPolicy put(final ActivityBasedTimeoutPolicy newActivityBasedTimeoutPolicy) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IActivityBasedTimeoutPolicyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IActivityBasedTimeoutPolicyRequest expand(final String value);

}

