// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IEventCancelRequest;
import com.microsoft.graph.requests.extensions.EventCancelRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Event Cancel Request Builder.
 */
public class EventCancelRequestBuilder extends BaseActionRequestBuilder implements IEventCancelRequestBuilder {

    /**
     * The request builder for this EventCancel
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param comment the comment
     */
    public EventCancelRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final String comment) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("comment", comment);
    }

    /**
     * Creates the IEventCancelRequest
     *
     * @param requestOptions the options for the request
     * @return the IEventCancelRequest instance
     */
    public IEventCancelRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IEventCancelRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IEventCancelRequest instance
     */
    public IEventCancelRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        EventCancelRequest request = new EventCancelRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("comment")) {
            request.body.comment = getParameter("comment");
        }

        return request;
    }
}
