// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.EducationUser;
import com.microsoft.graph.models.extensions.EducationSchool;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IEducationSchoolCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationSchoolCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.EducationSchoolCollectionResponse;
import com.microsoft.graph.models.extensions.EducationSchool;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education School Collection With References Page.
 */
public class EducationSchoolCollectionWithReferencesPage extends BaseCollectionPage<EducationSchool, IEducationSchoolCollectionWithReferencesRequestBuilder> implements IEducationSchoolCollectionWithReferencesPage {

    /**
     * A collection page for EducationSchool
     *
     * @param response the serialized EducationSchoolCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public EducationSchoolCollectionWithReferencesPage(final EducationSchoolCollectionResponse response, final IEducationSchoolCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }
}
