// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ExtensionProperty;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IDirectoryObjectGetAvailableExtensionPropertiesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetAvailableExtensionPropertiesCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetAvailableExtensionPropertiesCollectionResponse;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.IBaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Get Available Extension Properties Collection Page.
 */
public class DirectoryObjectGetAvailableExtensionPropertiesCollectionPage extends BaseCollectionPage<ExtensionProperty, IDirectoryObjectGetAvailableExtensionPropertiesCollectionRequestBuilder> implements IDirectoryObjectGetAvailableExtensionPropertiesCollectionPage {

    /**
     * A collection page for ExtensionProperty.
     *
     * @param response The serialized DirectoryObjectGetAvailableExtensionPropertiesCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public DirectoryObjectGetAvailableExtensionPropertiesCollectionPage(final DirectoryObjectGetAvailableExtensionPropertiesCollectionResponse response, final IDirectoryObjectGetAvailableExtensionPropertiesCollectionRequestBuilder builder) {
       super(response.value, builder, response.additionalDataManager());
    }
}
