// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Worksheet Protection Options.
 */
public class WorkbookWorksheetProtectionOptions implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Allow Auto Filter.
     * Represents the worksheet protection option of allowing using auto filter feature.
     */
    @SerializedName(value = "allowAutoFilter", alternate = {"AllowAutoFilter"})
    @Expose
    public Boolean allowAutoFilter;

    /**
     * The Allow Delete Columns.
     * Represents the worksheet protection option of allowing deleting columns.
     */
    @SerializedName(value = "allowDeleteColumns", alternate = {"AllowDeleteColumns"})
    @Expose
    public Boolean allowDeleteColumns;

    /**
     * The Allow Delete Rows.
     * Represents the worksheet protection option of allowing deleting rows.
     */
    @SerializedName(value = "allowDeleteRows", alternate = {"AllowDeleteRows"})
    @Expose
    public Boolean allowDeleteRows;

    /**
     * The Allow Format Cells.
     * Represents the worksheet protection option of allowing formatting cells.
     */
    @SerializedName(value = "allowFormatCells", alternate = {"AllowFormatCells"})
    @Expose
    public Boolean allowFormatCells;

    /**
     * The Allow Format Columns.
     * Represents the worksheet protection option of allowing formatting columns.
     */
    @SerializedName(value = "allowFormatColumns", alternate = {"AllowFormatColumns"})
    @Expose
    public Boolean allowFormatColumns;

    /**
     * The Allow Format Rows.
     * Represents the worksheet protection option of allowing formatting rows.
     */
    @SerializedName(value = "allowFormatRows", alternate = {"AllowFormatRows"})
    @Expose
    public Boolean allowFormatRows;

    /**
     * The Allow Insert Columns.
     * Represents the worksheet protection option of allowing inserting columns.
     */
    @SerializedName(value = "allowInsertColumns", alternate = {"AllowInsertColumns"})
    @Expose
    public Boolean allowInsertColumns;

    /**
     * The Allow Insert Hyperlinks.
     * Represents the worksheet protection option of allowing inserting hyperlinks.
     */
    @SerializedName(value = "allowInsertHyperlinks", alternate = {"AllowInsertHyperlinks"})
    @Expose
    public Boolean allowInsertHyperlinks;

    /**
     * The Allow Insert Rows.
     * Represents the worksheet protection option of allowing inserting rows.
     */
    @SerializedName(value = "allowInsertRows", alternate = {"AllowInsertRows"})
    @Expose
    public Boolean allowInsertRows;

    /**
     * The Allow Pivot Tables.
     * Represents the worksheet protection option of allowing using pivot table feature.
     */
    @SerializedName(value = "allowPivotTables", alternate = {"AllowPivotTables"})
    @Expose
    public Boolean allowPivotTables;

    /**
     * The Allow Sort.
     * Represents the worksheet protection option of allowing using sort feature.
     */
    @SerializedName(value = "allowSort", alternate = {"AllowSort"})
    @Expose
    public Boolean allowSort;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
