// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.WorkbookChartAxisFormat;
import com.microsoft.graph.models.extensions.WorkbookChartGridlines;
import com.microsoft.graph.models.extensions.WorkbookChartAxisTitle;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Axis.
 */
public class WorkbookChartAxis extends Entity implements IJsonBackedObject {


    /**
     * The Major Unit.
     * Represents the interval between two major tick marks. Can be set to a numeric value or an empty string.  The returned value is always a number.
     */
    @SerializedName(value = "majorUnit", alternate = {"MajorUnit"})
    @Expose
    public com.google.gson.JsonElement majorUnit;

    /**
     * The Maximum.
     * Represents the maximum value on the value axis.  Can be set to a numeric value or an empty string (for automatic axis values).  The returned value is always a number.
     */
    @SerializedName(value = "maximum", alternate = {"Maximum"})
    @Expose
    public com.google.gson.JsonElement maximum;

    /**
     * The Minimum.
     * Represents the minimum value on the value axis. Can be set to a numeric value or an empty string (for automatic axis values).  The returned value is always a number.
     */
    @SerializedName(value = "minimum", alternate = {"Minimum"})
    @Expose
    public com.google.gson.JsonElement minimum;

    /**
     * The Minor Unit.
     * Represents the interval between two minor tick marks. 'Can be set to a numeric value or an empty string (for automatic axis values). The returned value is always a number.
     */
    @SerializedName(value = "minorUnit", alternate = {"MinorUnit"})
    @Expose
    public com.google.gson.JsonElement minorUnit;

    /**
     * The Format.
     * Represents the formatting of a chart object, which includes line and font formatting. Read-only.
     */
    @SerializedName(value = "format", alternate = {"Format"})
    @Expose
    public WorkbookChartAxisFormat format;

    /**
     * The Major Gridlines.
     * Returns a gridlines object that represents the major gridlines for the specified axis. Read-only.
     */
    @SerializedName(value = "majorGridlines", alternate = {"MajorGridlines"})
    @Expose
    public WorkbookChartGridlines majorGridlines;

    /**
     * The Minor Gridlines.
     * Returns a Gridlines object that represents the minor gridlines for the specified axis. Read-only.
     */
    @SerializedName(value = "minorGridlines", alternate = {"MinorGridlines"})
    @Expose
    public WorkbookChartGridlines minorGridlines;

    /**
     * The Title.
     * Represents the axis title. Read-only.
     */
    @SerializedName(value = "title", alternate = {"Title"})
    @Expose
    public WorkbookChartAxisTitle title;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
