// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.IdentitySet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shared.
 */
public class Shared implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Owner.
     * The identity of the owner of the shared item. Read-only.
     */
    @SerializedName(value = "owner", alternate = {"Owner"})
    @Expose
    public IdentitySet owner;

    /**
     * The Scope.
     * Indicates the scope of how the item is shared: anonymous, organization, or users. Read-only.
     */
    @SerializedName(value = "scope", alternate = {"Scope"})
    @Expose
    public String scope;

    /**
     * The Shared By.
     * The identity of the user who shared the item. Read-only.
     */
    @SerializedName(value = "sharedBy", alternate = {"SharedBy"})
    @Expose
    public IdentitySet sharedBy;

    /**
     * The Shared Date Time.
     * The UTC date and time when the item was shared. Read-only.
     */
    @SerializedName(value = "sharedDateTime", alternate = {"SharedDateTime"})
    @Expose
    public java.util.Calendar sharedDateTime;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
