// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.MimeContent;
import com.microsoft.graph.models.extensions.RgbColor;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Intune Brand.
 */
public class IntuneBrand implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Contact ITEmail Address.
     * Email address of the person/organization responsible for IT support.
     */
    @SerializedName(value = "contactITEmailAddress", alternate = {"ContactITEmailAddress"})
    @Expose
    public String contactITEmailAddress;

    /**
     * The Contact ITName.
     * Name of the person/organization responsible for IT support.
     */
    @SerializedName(value = "contactITName", alternate = {"ContactITName"})
    @Expose
    public String contactITName;

    /**
     * The Contact ITNotes.
     * Text comments regarding the person/organization responsible for IT support.
     */
    @SerializedName(value = "contactITNotes", alternate = {"ContactITNotes"})
    @Expose
    public String contactITNotes;

    /**
     * The Contact ITPhone Number.
     * Phone number of the person/organization responsible for IT support.
     */
    @SerializedName(value = "contactITPhoneNumber", alternate = {"ContactITPhoneNumber"})
    @Expose
    public String contactITPhoneNumber;

    /**
     * The Dark Background Logo.
     * Logo image displayed in Company Portal apps which have a dark background behind the logo.
     */
    @SerializedName(value = "darkBackgroundLogo", alternate = {"DarkBackgroundLogo"})
    @Expose
    public MimeContent darkBackgroundLogo;

    /**
     * The Display Name.
     * Company/organization name that is displayed to end users.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
    public String displayName;

    /**
     * The Light Background Logo.
     * Logo image displayed in Company Portal apps which have a light background behind the logo.
     */
    @SerializedName(value = "lightBackgroundLogo", alternate = {"LightBackgroundLogo"})
    @Expose
    public MimeContent lightBackgroundLogo;

    /**
     * The Online Support Site Name.
     * Display name of the company/organization’s IT helpdesk site.
     */
    @SerializedName(value = "onlineSupportSiteName", alternate = {"OnlineSupportSiteName"})
    @Expose
    public String onlineSupportSiteName;

    /**
     * The Online Support Site Url.
     * URL to the company/organization’s IT helpdesk site.
     */
    @SerializedName(value = "onlineSupportSiteUrl", alternate = {"OnlineSupportSiteUrl"})
    @Expose
    public String onlineSupportSiteUrl;

    /**
     * The Privacy Url.
     * URL to the company/organization’s privacy policy.
     */
    @SerializedName(value = "privacyUrl", alternate = {"PrivacyUrl"})
    @Expose
    public String privacyUrl;

    /**
     * The Show Display Name Next To Logo.
     * Boolean that represents whether the administrator-supplied display name will be shown next to the logo image.
     */
    @SerializedName(value = "showDisplayNameNextToLogo", alternate = {"ShowDisplayNameNextToLogo"})
    @Expose
    public Boolean showDisplayNameNextToLogo;

    /**
     * The Show Logo.
     * Boolean that represents whether the administrator-supplied logo images are shown or not shown.
     */
    @SerializedName(value = "showLogo", alternate = {"ShowLogo"})
    @Expose
    public Boolean showLogo;

    /**
     * The Show Name Next To Logo.
     * Boolean that represents whether the administrator-supplied display name will be shown next to the logo image.
     */
    @SerializedName(value = "showNameNextToLogo", alternate = {"ShowNameNextToLogo"})
    @Expose
    public Boolean showNameNextToLogo;

    /**
     * The Theme Color.
     * Primary theme color used in the Company Portal applications and web portal.
     */
    @SerializedName(value = "themeColor", alternate = {"ThemeColor"})
    @Expose
    public RgbColor themeColor;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
