// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;

import com.microsoft.graph.models.extensions.Prompt;
import com.microsoft.graph.models.extensions.RecordOperation;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.JsonObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Record Response Body.
 */
public class CallRecordResponseBody {

    /**
     * The prompts.
     * 
     */
    @SerializedName(value = "prompts", alternate = {"Prompts"})
    @Expose
    public java.util.List<Prompt> prompts;

    /**
     * The barge In Allowed.
     * 
     */
    @SerializedName(value = "bargeInAllowed", alternate = {"BargeInAllowed"})
    @Expose
    public Boolean bargeInAllowed;

    /**
     * The initial Silence Timeout In Seconds.
     * 
     */
    @SerializedName(value = "initialSilenceTimeoutInSeconds", alternate = {"InitialSilenceTimeoutInSeconds"})
    @Expose
    public Integer initialSilenceTimeoutInSeconds;

    /**
     * The max Silence Timeout In Seconds.
     * 
     */
    @SerializedName(value = "maxSilenceTimeoutInSeconds", alternate = {"MaxSilenceTimeoutInSeconds"})
    @Expose
    public Integer maxSilenceTimeoutInSeconds;

    /**
     * The max Record Duration In Seconds.
     * 
     */
    @SerializedName(value = "maxRecordDurationInSeconds", alternate = {"MaxRecordDurationInSeconds"})
    @Expose
    public Integer maxRecordDurationInSeconds;

    /**
     * The play Beep.
     * 
     */
    @SerializedName(value = "playBeep", alternate = {"PlayBeep"})
    @Expose
    public Boolean playBeep;

    /**
     * The stop Tones.
     * 
     */
    @SerializedName(value = "stopTones", alternate = {"StopTones"})
    @Expose
    public java.util.List<String> stopTones;

    /**
     * The client Context.
     * 
     */
    @SerializedName(value = "clientContext", alternate = {"ClientContext"})
    @Expose
    public String clientContext;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
