/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IProgressCallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.http.IHttpStreamRequest;
import com.microsoft.graph.httpcore.middlewareoption.IShouldRedirect;
import com.microsoft.graph.httpcore.middlewareoption.IShouldRetry;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.Option;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import okhttp3.Request;

public abstract class BaseStreamRequest<T>
implements IHttpStreamRequest {
    private final BaseRequest baseRequest;

    public BaseStreamRequest(String requestUrl, IBaseClient client, List<? extends Option> options, Class<T> responseClass) {
        this.baseRequest = new BaseRequest(requestUrl, client, options, responseClass){};
    }

    protected void send(ICallback<InputStream> callback) {
        this.baseRequest.setHttpMethod(HttpMethod.GET);
        this.baseRequest.getClient().getHttpProvider().send((IHttpRequest)this, callback, InputStream.class, null);
    }

    protected InputStream send() throws ClientException {
        this.baseRequest.setHttpMethod(HttpMethod.GET);
        return this.baseRequest.getClient().getHttpProvider().send(this, InputStream.class, null);
    }

    protected void send(byte[] fileContents, ICallback<? super T> callback) {
        this.baseRequest.setHttpMethod(HttpMethod.PUT);
        this.baseRequest.getClient().getHttpProvider().send((IHttpRequest)this, callback, this.baseRequest.getResponseType(), fileContents);
    }

    protected T send(byte[] fileContents) {
        this.baseRequest.setHttpMethod(HttpMethod.PUT);
        return (T)this.baseRequest.getClient().getHttpProvider().send(this, this.baseRequest.getResponseType(), fileContents);
    }

    @Override
    public URL getRequestUrl() {
        return this.baseRequest.getRequestUrl();
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.baseRequest.getHttpMethod();
    }

    @Override
    public void addHeader(String header, String value) {
        this.baseRequest.addHeader(header, value);
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.baseRequest.setUseCaches(useCaches);
    }

    @Override
    public boolean getUseCaches() {
        return this.baseRequest.getUseCaches();
    }

    @Override
    public List<HeaderOption> getHeaders() {
        return this.baseRequest.getHeaders();
    }

    @Override
    public List<Option> getOptions() {
        return this.baseRequest.getOptions();
    }

    @Override
    public void setMaxRedirects(int maxRedirects) {
        this.baseRequest.setMaxRedirects(maxRedirects);
    }

    @Override
    public int getMaxRedirects() {
        return this.baseRequest.getMaxRedirects();
    }

    @Override
    public void setShouldRedirect(IShouldRedirect shouldRedirect) {
        this.baseRequest.setShouldRedirect(shouldRedirect);
    }

    @Override
    public IShouldRedirect getShouldRedirect() {
        return this.baseRequest.getShouldRedirect();
    }

    @Override
    public void setShouldRetry(IShouldRetry shouldretry) {
        this.baseRequest.setShouldRetry(shouldretry);
    }

    @Override
    public IShouldRetry getShouldRetry() {
        return this.baseRequest.getShouldRetry();
    }

    @Override
    public void setMaxRetries(int maxRetries) {
        this.baseRequest.setMaxRetries(maxRetries);
    }

    @Override
    public int getMaxRetries() {
        return this.baseRequest.getMaxRetries();
    }

    @Override
    public void setDelay(long delay) {
        this.baseRequest.setDelay(delay);
    }

    @Override
    public long getDelay() {
        return this.baseRequest.getDelay();
    }

    @Override
    public IHttpRequest withHttpMethod(HttpMethod httpMethod) {
        this.baseRequest.setHttpMethod(httpMethod);
        return this;
    }

    @Override
    public Request getHttpRequest() throws ClientException {
        return this.baseRequest.getHttpRequest();
    }

    @Override
    public <requestBodyType> Request getHttpRequest(requestBodyType serializedObject) throws ClientException {
        return this.baseRequest.getHttpRequest(serializedObject);
    }

    @Override
    public <requestBodyType, responseType> Request getHttpRequest(requestBodyType serializedObject, IProgressCallback<responseType> progress) throws ClientException {
        return this.baseRequest.getHttpRequest(serializedObject, progress);
    }
}

