/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OnenoteSection;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOnenoteSectionCollectionPage;
import com.microsoft.graph.requests.extensions.IOnenoteSectionCollectionRequest;
import com.microsoft.graph.requests.extensions.OnenoteSectionCollectionPage;
import com.microsoft.graph.requests.extensions.OnenoteSectionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OnenoteSectionCollectionResponse;
import com.microsoft.graph.requests.extensions.OnenoteSectionRequestBuilder;
import java.util.List;

public class OnenoteSectionCollectionRequest
extends BaseCollectionRequest<OnenoteSectionCollectionResponse, IOnenoteSectionCollectionPage>
implements IOnenoteSectionCollectionRequest {
    public OnenoteSectionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnenoteSectionCollectionResponse.class, IOnenoteSectionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IOnenoteSectionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OnenoteSectionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOnenoteSectionCollectionPage get() throws ClientException {
        OnenoteSectionCollectionResponse response = (OnenoteSectionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OnenoteSection newOnenoteSection, ICallback<? super OnenoteSection> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OnenoteSectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOnenoteSection, callback);
    }

    @Override
    public OnenoteSection post(OnenoteSection newOnenoteSection) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OnenoteSectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOnenoteSection);
    }

    @Override
    public IOnenoteSectionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOnenoteSectionCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IOnenoteSectionCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IOnenoteSectionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOnenoteSectionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IOnenoteSectionCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IOnenoteSectionCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IOnenoteSectionCollectionPage buildFromResponse(OnenoteSectionCollectionResponse response) {
        OnenoteSectionCollectionRequestBuilder builder = response.nextLink != null ? new OnenoteSectionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OnenoteSectionCollectionPage page = new OnenoteSectionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

