/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Endpoint;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IEndpointReferenceRequest;
import java.util.List;

public class EndpointReferenceRequest
extends BaseRequest
implements IEndpointReferenceRequest {
    public EndpointReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Endpoint.class);
    }

    @Override
    public void delete(ICallback<? super Endpoint> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public Endpoint delete() throws ClientException {
        return (Endpoint)this.send(HttpMethod.DELETE, null);
    }

    @Override
    public IEndpointReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEndpointReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public void put(Endpoint srcEndpoint, ICallback<? super Endpoint> callback) {
        this.send(HttpMethod.PUT, callback, srcEndpoint);
    }

    @Override
    public Endpoint put(Endpoint srcEndpoint) throws ClientException {
        return (Endpoint)this.send(HttpMethod.PUT, srcEndpoint);
    }
}

