/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WindowsInformationProtectionNetworkLearningSummary;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWindowsInformationProtectionNetworkLearningSummaryCollectionPage;
import com.microsoft.graph.requests.extensions.IWindowsInformationProtectionNetworkLearningSummaryCollectionRequest;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionNetworkLearningSummaryCollectionPage;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionNetworkLearningSummaryCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionNetworkLearningSummaryCollectionResponse;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionNetworkLearningSummaryRequestBuilder;
import java.util.List;

public class WindowsInformationProtectionNetworkLearningSummaryCollectionRequest
extends BaseCollectionRequest<WindowsInformationProtectionNetworkLearningSummaryCollectionResponse, IWindowsInformationProtectionNetworkLearningSummaryCollectionPage>
implements IWindowsInformationProtectionNetworkLearningSummaryCollectionRequest {
    public WindowsInformationProtectionNetworkLearningSummaryCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsInformationProtectionNetworkLearningSummaryCollectionResponse.class, IWindowsInformationProtectionNetworkLearningSummaryCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWindowsInformationProtectionNetworkLearningSummaryCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WindowsInformationProtectionNetworkLearningSummaryCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWindowsInformationProtectionNetworkLearningSummaryCollectionPage get() throws ClientException {
        WindowsInformationProtectionNetworkLearningSummaryCollectionResponse response = (WindowsInformationProtectionNetworkLearningSummaryCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WindowsInformationProtectionNetworkLearningSummary newWindowsInformationProtectionNetworkLearningSummary, ICallback<WindowsInformationProtectionNetworkLearningSummary> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WindowsInformationProtectionNetworkLearningSummaryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWindowsInformationProtectionNetworkLearningSummary, callback);
    }

    @Override
    public WindowsInformationProtectionNetworkLearningSummary post(WindowsInformationProtectionNetworkLearningSummary newWindowsInformationProtectionNetworkLearningSummary) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WindowsInformationProtectionNetworkLearningSummaryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWindowsInformationProtectionNetworkLearningSummary);
    }

    @Override
    public IWindowsInformationProtectionNetworkLearningSummaryCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionNetworkLearningSummaryCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionNetworkLearningSummaryCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionNetworkLearningSummaryCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWindowsInformationProtectionNetworkLearningSummaryCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWindowsInformationProtectionNetworkLearningSummaryCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWindowsInformationProtectionNetworkLearningSummaryCollectionPage buildFromResponse(WindowsInformationProtectionNetworkLearningSummaryCollectionResponse response) {
        WindowsInformationProtectionNetworkLearningSummaryCollectionRequestBuilder builder = response.nextLink != null ? new WindowsInformationProtectionNetworkLearningSummaryCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WindowsInformationProtectionNetworkLearningSummaryCollectionPage page = new WindowsInformationProtectionNetworkLearningSummaryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

