/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ThumbnailSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IThumbnailSetRequest;
import java.util.List;

public class ThumbnailSetRequest
extends BaseRequest
implements IThumbnailSetRequest {
    public ThumbnailSetRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ThumbnailSet.class);
    }

    @Override
    public void get(ICallback<ThumbnailSet> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ThumbnailSet get() throws ClientException {
        return (ThumbnailSet)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<ThumbnailSet> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ThumbnailSet sourceThumbnailSet, ICallback<ThumbnailSet> callback) {
        this.send(HttpMethod.PATCH, callback, sourceThumbnailSet);
    }

    @Override
    public ThumbnailSet patch(ThumbnailSet sourceThumbnailSet) throws ClientException {
        return (ThumbnailSet)this.send(HttpMethod.PATCH, sourceThumbnailSet);
    }

    @Override
    public void post(ThumbnailSet newThumbnailSet, ICallback<ThumbnailSet> callback) {
        this.send(HttpMethod.POST, callback, newThumbnailSet);
    }

    @Override
    public ThumbnailSet post(ThumbnailSet newThumbnailSet) throws ClientException {
        return (ThumbnailSet)this.send(HttpMethod.POST, newThumbnailSet);
    }

    @Override
    public void put(ThumbnailSet newThumbnailSet, ICallback<ThumbnailSet> callback) {
        this.send(HttpMethod.PUT, callback, newThumbnailSet);
    }

    @Override
    public ThumbnailSet put(ThumbnailSet newThumbnailSet) throws ClientException {
        return (ThumbnailSet)this.send(HttpMethod.PUT, newThumbnailSet);
    }

    @Override
    public IThumbnailSetRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IThumbnailSetRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IThumbnailSetRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

