/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Subscription;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISubscriptionRequest;
import java.util.List;

public class SubscriptionRequest
extends BaseRequest
implements ISubscriptionRequest {
    public SubscriptionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Subscription.class);
    }

    @Override
    public void get(ICallback<Subscription> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Subscription get() throws ClientException {
        return (Subscription)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Subscription> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Subscription sourceSubscription, ICallback<Subscription> callback) {
        this.send(HttpMethod.PATCH, callback, sourceSubscription);
    }

    @Override
    public Subscription patch(Subscription sourceSubscription) throws ClientException {
        return (Subscription)this.send(HttpMethod.PATCH, sourceSubscription);
    }

    @Override
    public void post(Subscription newSubscription, ICallback<Subscription> callback) {
        this.send(HttpMethod.POST, callback, newSubscription);
    }

    @Override
    public Subscription post(Subscription newSubscription) throws ClientException {
        return (Subscription)this.send(HttpMethod.POST, newSubscription);
    }

    @Override
    public void put(Subscription newSubscription, ICallback<Subscription> callback) {
        this.send(HttpMethod.PUT, callback, newSubscription);
    }

    @Override
    public Subscription put(Subscription newSubscription) throws ClientException {
        return (Subscription)this.send(HttpMethod.PUT, newSubscription);
    }

    @Override
    public ISubscriptionRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISubscriptionRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public ISubscriptionRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

