/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Shift;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IShiftCollectionPage;
import com.microsoft.graph.requests.extensions.IShiftCollectionRequest;
import com.microsoft.graph.requests.extensions.ShiftCollectionPage;
import com.microsoft.graph.requests.extensions.ShiftCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ShiftCollectionResponse;
import com.microsoft.graph.requests.extensions.ShiftRequestBuilder;
import java.util.List;

public class ShiftCollectionRequest
extends BaseCollectionRequest<ShiftCollectionResponse, IShiftCollectionPage>
implements IShiftCollectionRequest {
    public ShiftCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ShiftCollectionResponse.class, IShiftCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IShiftCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ShiftCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IShiftCollectionPage get() throws ClientException {
        ShiftCollectionResponse response = (ShiftCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Shift newShift, ICallback<Shift> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ShiftRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newShift, callback);
    }

    @Override
    public Shift post(Shift newShift) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ShiftRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newShift);
    }

    @Override
    public IShiftCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IShiftCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IShiftCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IShiftCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IShiftCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IShiftCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IShiftCollectionPage buildFromResponse(ShiftCollectionResponse response) {
        ShiftCollectionRequestBuilder builder = response.nextLink != null ? new ShiftCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ShiftCollectionPage page = new ShiftCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

