/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ServicePrincipal;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IServicePrincipalCollectionPage;
import com.microsoft.graph.requests.extensions.IServicePrincipalCollectionRequest;
import com.microsoft.graph.requests.extensions.ServicePrincipalCollectionPage;
import com.microsoft.graph.requests.extensions.ServicePrincipalCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ServicePrincipalCollectionResponse;
import com.microsoft.graph.requests.extensions.ServicePrincipalRequestBuilder;
import java.util.List;

public class ServicePrincipalCollectionRequest
extends BaseCollectionRequest<ServicePrincipalCollectionResponse, IServicePrincipalCollectionPage>
implements IServicePrincipalCollectionRequest {
    public ServicePrincipalCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServicePrincipalCollectionResponse.class, IServicePrincipalCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IServicePrincipalCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ServicePrincipalCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IServicePrincipalCollectionPage get() throws ClientException {
        ServicePrincipalCollectionResponse response = (ServicePrincipalCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ServicePrincipal newServicePrincipal, ICallback<ServicePrincipal> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ServicePrincipalRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newServicePrincipal, callback);
    }

    @Override
    public ServicePrincipal post(ServicePrincipal newServicePrincipal) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ServicePrincipalRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newServicePrincipal);
    }

    @Override
    public IServicePrincipalCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IServicePrincipalCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IServicePrincipalCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IServicePrincipalCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IServicePrincipalCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IServicePrincipalCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IServicePrincipalCollectionPage buildFromResponse(ServicePrincipalCollectionResponse response) {
        ServicePrincipalCollectionRequestBuilder builder = response.nextLink != null ? new ServicePrincipalCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ServicePrincipalCollectionPage page = new ServicePrincipalCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

