/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ScopedRoleMembership;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IScopedRoleMembershipCollectionPage;
import com.microsoft.graph.requests.extensions.IScopedRoleMembershipCollectionRequest;
import com.microsoft.graph.requests.extensions.ScopedRoleMembershipCollectionPage;
import com.microsoft.graph.requests.extensions.ScopedRoleMembershipCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ScopedRoleMembershipCollectionResponse;
import com.microsoft.graph.requests.extensions.ScopedRoleMembershipRequestBuilder;
import java.util.List;

public class ScopedRoleMembershipCollectionRequest
extends BaseCollectionRequest<ScopedRoleMembershipCollectionResponse, IScopedRoleMembershipCollectionPage>
implements IScopedRoleMembershipCollectionRequest {
    public ScopedRoleMembershipCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ScopedRoleMembershipCollectionResponse.class, IScopedRoleMembershipCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IScopedRoleMembershipCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ScopedRoleMembershipCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IScopedRoleMembershipCollectionPage get() throws ClientException {
        ScopedRoleMembershipCollectionResponse response = (ScopedRoleMembershipCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ScopedRoleMembership newScopedRoleMembership, ICallback<ScopedRoleMembership> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ScopedRoleMembershipRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newScopedRoleMembership, callback);
    }

    @Override
    public ScopedRoleMembership post(ScopedRoleMembership newScopedRoleMembership) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ScopedRoleMembershipRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newScopedRoleMembership);
    }

    @Override
    public IScopedRoleMembershipCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IScopedRoleMembershipCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IScopedRoleMembershipCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IScopedRoleMembershipCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IScopedRoleMembershipCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IScopedRoleMembershipCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IScopedRoleMembershipCollectionPage buildFromResponse(ScopedRoleMembershipCollectionResponse response) {
        ScopedRoleMembershipCollectionRequestBuilder builder = response.nextLink != null ? new ScopedRoleMembershipCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ScopedRoleMembershipCollectionPage page = new ScopedRoleMembershipCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

