/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SchedulingGroup;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISchedulingGroupCollectionPage;
import com.microsoft.graph.requests.extensions.ISchedulingGroupCollectionRequest;
import com.microsoft.graph.requests.extensions.SchedulingGroupCollectionPage;
import com.microsoft.graph.requests.extensions.SchedulingGroupCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SchedulingGroupCollectionResponse;
import com.microsoft.graph.requests.extensions.SchedulingGroupRequestBuilder;
import java.util.List;

public class SchedulingGroupCollectionRequest
extends BaseCollectionRequest<SchedulingGroupCollectionResponse, ISchedulingGroupCollectionPage>
implements ISchedulingGroupCollectionRequest {
    public SchedulingGroupCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SchedulingGroupCollectionResponse.class, ISchedulingGroupCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISchedulingGroupCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SchedulingGroupCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISchedulingGroupCollectionPage get() throws ClientException {
        SchedulingGroupCollectionResponse response = (SchedulingGroupCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SchedulingGroup newSchedulingGroup, ICallback<SchedulingGroup> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SchedulingGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSchedulingGroup, callback);
    }

    @Override
    public SchedulingGroup post(SchedulingGroup newSchedulingGroup) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SchedulingGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSchedulingGroup);
    }

    @Override
    public ISchedulingGroupCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISchedulingGroupCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ISchedulingGroupCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISchedulingGroupCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISchedulingGroupCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISchedulingGroupCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISchedulingGroupCollectionPage buildFromResponse(SchedulingGroupCollectionResponse response) {
        SchedulingGroupCollectionRequestBuilder builder = response.nextLink != null ? new SchedulingGroupCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SchedulingGroupCollectionPage page = new SchedulingGroupCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

