/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.PolicyRoot;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPolicyRootRequest;
import java.util.List;

public class PolicyRootRequest
extends BaseRequest
implements IPolicyRootRequest {
    public PolicyRootRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PolicyRoot.class);
    }

    @Override
    public void get(ICallback<PolicyRoot> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public PolicyRoot get() throws ClientException {
        return (PolicyRoot)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<PolicyRoot> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(PolicyRoot sourcePolicyRoot, ICallback<PolicyRoot> callback) {
        this.send(HttpMethod.PATCH, callback, sourcePolicyRoot);
    }

    @Override
    public PolicyRoot patch(PolicyRoot sourcePolicyRoot) throws ClientException {
        return (PolicyRoot)this.send(HttpMethod.PATCH, sourcePolicyRoot);
    }

    @Override
    public void post(PolicyRoot newPolicyRoot, ICallback<PolicyRoot> callback) {
        this.send(HttpMethod.POST, callback, newPolicyRoot);
    }

    @Override
    public PolicyRoot post(PolicyRoot newPolicyRoot) throws ClientException {
        return (PolicyRoot)this.send(HttpMethod.POST, newPolicyRoot);
    }

    @Override
    public void put(PolicyRoot newPolicyRoot, ICallback<PolicyRoot> callback) {
        this.send(HttpMethod.PUT, callback, newPolicyRoot);
    }

    @Override
    public PolicyRoot put(PolicyRoot newPolicyRoot) throws ClientException {
        return (PolicyRoot)this.send(HttpMethod.PUT, newPolicyRoot);
    }

    @Override
    public IPolicyRootRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPolicyRootRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IPolicyRootRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

