/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PlannerTask;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPlannerTaskCollectionPage;
import com.microsoft.graph.requests.extensions.IPlannerTaskCollectionRequest;
import com.microsoft.graph.requests.extensions.PlannerTaskCollectionPage;
import com.microsoft.graph.requests.extensions.PlannerTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PlannerTaskCollectionResponse;
import com.microsoft.graph.requests.extensions.PlannerTaskRequestBuilder;
import java.util.List;

public class PlannerTaskCollectionRequest
extends BaseCollectionRequest<PlannerTaskCollectionResponse, IPlannerTaskCollectionPage>
implements IPlannerTaskCollectionRequest {
    public PlannerTaskCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PlannerTaskCollectionResponse.class, IPlannerTaskCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPlannerTaskCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PlannerTaskCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPlannerTaskCollectionPage get() throws ClientException {
        PlannerTaskCollectionResponse response = (PlannerTaskCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PlannerTask newPlannerTask, ICallback<PlannerTask> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PlannerTaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPlannerTask, callback);
    }

    @Override
    public PlannerTask post(PlannerTask newPlannerTask) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PlannerTaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPlannerTask);
    }

    @Override
    public IPlannerTaskCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPlannerTaskCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPlannerTaskCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPlannerTaskCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPlannerTaskCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPlannerTaskCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPlannerTaskCollectionPage buildFromResponse(PlannerTaskCollectionResponse response) {
        PlannerTaskCollectionRequestBuilder builder = response.nextLink != null ? new PlannerTaskCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PlannerTaskCollectionPage page = new PlannerTaskCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

