/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedAppPolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedAppPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedAppPolicyCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedAppPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedAppPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedAppPolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.ManagedAppPolicyRequestBuilder;
import java.util.List;

public class ManagedAppPolicyCollectionRequest
extends BaseCollectionRequest<ManagedAppPolicyCollectionResponse, IManagedAppPolicyCollectionPage>
implements IManagedAppPolicyCollectionRequest {
    public ManagedAppPolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedAppPolicyCollectionResponse.class, IManagedAppPolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedAppPolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ManagedAppPolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedAppPolicyCollectionPage get() throws ClientException {
        ManagedAppPolicyCollectionResponse response = (ManagedAppPolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedAppPolicy newManagedAppPolicy, ICallback<ManagedAppPolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedAppPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedAppPolicy, callback);
    }

    @Override
    public ManagedAppPolicy post(ManagedAppPolicy newManagedAppPolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedAppPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedAppPolicy);
    }

    @Override
    public IManagedAppPolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IManagedAppPolicyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IManagedAppPolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IManagedAppPolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IManagedAppPolicyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IManagedAppPolicyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IManagedAppPolicyCollectionPage buildFromResponse(ManagedAppPolicyCollectionResponse response) {
        ManagedAppPolicyCollectionRequestBuilder builder = response.nextLink != null ? new ManagedAppPolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedAppPolicyCollectionPage page = new ManagedAppPolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

