/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ItemActivityStat;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IItemActivityStatWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class ItemActivityStatWithReferenceRequest
extends BaseRequest
implements IItemActivityStatWithReferenceRequest {
    public ItemActivityStatWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemActivityStat.class);
    }

    @Override
    public void post(ItemActivityStat newItemActivityStat, IJsonBackedObject payload, ICallback<ItemActivityStat> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public ItemActivityStat post(ItemActivityStat newItemActivityStat, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newItemActivityStat;
        }
        return null;
    }

    @Override
    public void get(ICallback<ItemActivityStat> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ItemActivityStat get() throws ClientException {
        return (ItemActivityStat)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<ItemActivityStat> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ItemActivityStat sourceItemActivityStat, ICallback<ItemActivityStat> callback) {
        this.send(HttpMethod.PATCH, callback, sourceItemActivityStat);
    }

    @Override
    public ItemActivityStat patch(ItemActivityStat sourceItemActivityStat) throws ClientException {
        return (ItemActivityStat)this.send(HttpMethod.PATCH, sourceItemActivityStat);
    }

    @Override
    public IItemActivityStatWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IItemActivityStatWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IItemActivityStatWithReferenceRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

