/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.HomeRealmDiscoveryPolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.HomeRealmDiscoveryPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.HomeRealmDiscoveryPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.HomeRealmDiscoveryPolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.HomeRealmDiscoveryPolicyRequestBuilder;
import com.microsoft.graph.requests.extensions.IHomeRealmDiscoveryPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IHomeRealmDiscoveryPolicyCollectionRequest;
import java.util.List;

public class HomeRealmDiscoveryPolicyCollectionRequest
extends BaseCollectionRequest<HomeRealmDiscoveryPolicyCollectionResponse, IHomeRealmDiscoveryPolicyCollectionPage>
implements IHomeRealmDiscoveryPolicyCollectionRequest {
    public HomeRealmDiscoveryPolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HomeRealmDiscoveryPolicyCollectionResponse.class, IHomeRealmDiscoveryPolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IHomeRealmDiscoveryPolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(HomeRealmDiscoveryPolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IHomeRealmDiscoveryPolicyCollectionPage get() throws ClientException {
        HomeRealmDiscoveryPolicyCollectionResponse response = (HomeRealmDiscoveryPolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(HomeRealmDiscoveryPolicy newHomeRealmDiscoveryPolicy, ICallback<HomeRealmDiscoveryPolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new HomeRealmDiscoveryPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newHomeRealmDiscoveryPolicy, callback);
    }

    @Override
    public HomeRealmDiscoveryPolicy post(HomeRealmDiscoveryPolicy newHomeRealmDiscoveryPolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new HomeRealmDiscoveryPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newHomeRealmDiscoveryPolicy);
    }

    @Override
    public IHomeRealmDiscoveryPolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IHomeRealmDiscoveryPolicyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IHomeRealmDiscoveryPolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IHomeRealmDiscoveryPolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IHomeRealmDiscoveryPolicyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IHomeRealmDiscoveryPolicyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IHomeRealmDiscoveryPolicyCollectionPage buildFromResponse(HomeRealmDiscoveryPolicyCollectionResponse response) {
        HomeRealmDiscoveryPolicyCollectionRequestBuilder builder = response.nextLink != null ? new HomeRealmDiscoveryPolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        HomeRealmDiscoveryPolicyCollectionPage page = new HomeRealmDiscoveryPolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

