/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.FieldValueSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IFieldValueSetRequest;
import java.util.List;

public class FieldValueSetRequest
extends BaseRequest
implements IFieldValueSetRequest {
    public FieldValueSetRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, FieldValueSet.class);
    }

    @Override
    public void get(ICallback<FieldValueSet> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public FieldValueSet get() throws ClientException {
        return (FieldValueSet)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<FieldValueSet> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(FieldValueSet sourceFieldValueSet, ICallback<FieldValueSet> callback) {
        this.send(HttpMethod.PATCH, callback, sourceFieldValueSet);
    }

    @Override
    public FieldValueSet patch(FieldValueSet sourceFieldValueSet) throws ClientException {
        return (FieldValueSet)this.send(HttpMethod.PATCH, sourceFieldValueSet);
    }

    @Override
    public void post(FieldValueSet newFieldValueSet, ICallback<FieldValueSet> callback) {
        this.send(HttpMethod.POST, callback, newFieldValueSet);
    }

    @Override
    public FieldValueSet post(FieldValueSet newFieldValueSet) throws ClientException {
        return (FieldValueSet)this.send(HttpMethod.POST, newFieldValueSet);
    }

    @Override
    public void put(FieldValueSet newFieldValueSet, ICallback<FieldValueSet> callback) {
        this.send(HttpMethod.PUT, callback, newFieldValueSet);
    }

    @Override
    public FieldValueSet put(FieldValueSet newFieldValueSet) throws ClientException {
        return (FieldValueSet)this.send(HttpMethod.PUT, newFieldValueSet);
    }

    @Override
    public IFieldValueSetRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IFieldValueSetRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IFieldValueSetRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

