/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IEntityReferenceRequest;
import java.util.List;

public class EntityReferenceRequest
extends BaseRequest
implements IEntityReferenceRequest {
    public EntityReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Entity.class);
    }

    @Override
    public void delete(ICallback<Entity> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public Entity delete() throws ClientException {
        return (Entity)this.send(HttpMethod.DELETE, null);
    }

    @Override
    public IEntityReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEntityReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IEntityReferenceRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public void put(Entity srcEntity, ICallback<Entity> callback) {
        this.send(HttpMethod.PUT, callback, srcEntity);
    }

    @Override
    public Entity put(Entity srcEntity) throws ClientException {
        return (Entity)this.send(HttpMethod.PUT, srcEntity);
    }
}

