/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DirectoryRole;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DirectoryRoleCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryRoleCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryRoleCollectionResponse;
import com.microsoft.graph.requests.extensions.DirectoryRoleRequestBuilder;
import com.microsoft.graph.requests.extensions.IDirectoryRoleCollectionPage;
import com.microsoft.graph.requests.extensions.IDirectoryRoleCollectionRequest;
import java.util.List;

public class DirectoryRoleCollectionRequest
extends BaseCollectionRequest<DirectoryRoleCollectionResponse, IDirectoryRoleCollectionPage>
implements IDirectoryRoleCollectionRequest {
    public DirectoryRoleCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryRoleCollectionResponse.class, IDirectoryRoleCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDirectoryRoleCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DirectoryRoleCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryRoleCollectionPage get() throws ClientException {
        DirectoryRoleCollectionResponse response = (DirectoryRoleCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DirectoryRole newDirectoryRole, ICallback<DirectoryRole> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DirectoryRoleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDirectoryRole, callback);
    }

    @Override
    public DirectoryRole post(DirectoryRole newDirectoryRole) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DirectoryRoleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDirectoryRole);
    }

    @Override
    public IDirectoryRoleCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDirectoryRoleCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDirectoryRoleCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDirectoryRoleCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDirectoryRoleCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDirectoryRoleCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDirectoryRoleCollectionPage buildFromResponse(DirectoryRoleCollectionResponse response) {
        DirectoryRoleCollectionRequestBuilder builder = response.nextLink != null ? new DirectoryRoleCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DirectoryRoleCollectionPage page = new DirectoryRoleCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

