/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Contact;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ContactCollectionPage;
import com.microsoft.graph.requests.extensions.ContactCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ContactCollectionResponse;
import com.microsoft.graph.requests.extensions.ContactRequestBuilder;
import com.microsoft.graph.requests.extensions.IContactCollectionPage;
import com.microsoft.graph.requests.extensions.IContactCollectionRequest;
import java.util.List;

public class ContactCollectionRequest
extends BaseCollectionRequest<ContactCollectionResponse, IContactCollectionPage>
implements IContactCollectionRequest {
    public ContactCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContactCollectionResponse.class, IContactCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IContactCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ContactCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IContactCollectionPage get() throws ClientException {
        ContactCollectionResponse response = (ContactCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Contact newContact, ICallback<Contact> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ContactRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newContact, callback);
    }

    @Override
    public Contact post(Contact newContact) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ContactRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newContact);
    }

    @Override
    public IContactCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IContactCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IContactCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IContactCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IContactCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IContactCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IContactCollectionPage buildFromResponse(ContactCollectionResponse response) {
        ContactCollectionRequestBuilder builder = response.nextLink != null ? new ContactCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ContactCollectionPage page = new ContactCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

