/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ColumnDefinition;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ColumnDefinitionCollectionPage;
import com.microsoft.graph.requests.extensions.ColumnDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ColumnDefinitionCollectionResponse;
import com.microsoft.graph.requests.extensions.ColumnDefinitionRequestBuilder;
import com.microsoft.graph.requests.extensions.IColumnDefinitionCollectionPage;
import com.microsoft.graph.requests.extensions.IColumnDefinitionCollectionRequest;
import java.util.List;

public class ColumnDefinitionCollectionRequest
extends BaseCollectionRequest<ColumnDefinitionCollectionResponse, IColumnDefinitionCollectionPage>
implements IColumnDefinitionCollectionRequest {
    public ColumnDefinitionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ColumnDefinitionCollectionResponse.class, IColumnDefinitionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IColumnDefinitionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ColumnDefinitionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IColumnDefinitionCollectionPage get() throws ClientException {
        ColumnDefinitionCollectionResponse response = (ColumnDefinitionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ColumnDefinition newColumnDefinition, ICallback<ColumnDefinition> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ColumnDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newColumnDefinition, callback);
    }

    @Override
    public ColumnDefinition post(ColumnDefinition newColumnDefinition) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ColumnDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newColumnDefinition);
    }

    @Override
    public IColumnDefinitionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IColumnDefinitionCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IColumnDefinitionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IColumnDefinitionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IColumnDefinitionCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IColumnDefinitionCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IColumnDefinitionCollectionPage buildFromResponse(ColumnDefinitionCollectionResponse response) {
        ColumnDefinitionCollectionRequestBuilder builder = response.nextLink != null ? new ColumnDefinitionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ColumnDefinitionCollectionPage page = new ColumnDefinitionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

