/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ClaimsMappingPolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ClaimsMappingPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.ClaimsMappingPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ClaimsMappingPolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.ClaimsMappingPolicyRequestBuilder;
import com.microsoft.graph.requests.extensions.IClaimsMappingPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IClaimsMappingPolicyCollectionRequest;
import java.util.List;

public class ClaimsMappingPolicyCollectionRequest
extends BaseCollectionRequest<ClaimsMappingPolicyCollectionResponse, IClaimsMappingPolicyCollectionPage>
implements IClaimsMappingPolicyCollectionRequest {
    public ClaimsMappingPolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ClaimsMappingPolicyCollectionResponse.class, IClaimsMappingPolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IClaimsMappingPolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ClaimsMappingPolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IClaimsMappingPolicyCollectionPage get() throws ClientException {
        ClaimsMappingPolicyCollectionResponse response = (ClaimsMappingPolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ClaimsMappingPolicy newClaimsMappingPolicy, ICallback<ClaimsMappingPolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ClaimsMappingPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newClaimsMappingPolicy, callback);
    }

    @Override
    public ClaimsMappingPolicy post(ClaimsMappingPolicy newClaimsMappingPolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ClaimsMappingPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newClaimsMappingPolicy);
    }

    @Override
    public IClaimsMappingPolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IClaimsMappingPolicyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IClaimsMappingPolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IClaimsMappingPolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IClaimsMappingPolicyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IClaimsMappingPolicyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IClaimsMappingPolicyCollectionPage buildFromResponse(ClaimsMappingPolicyCollectionResponse response) {
        ClaimsMappingPolicyCollectionRequestBuilder builder = response.nextLink != null ? new ClaimsMappingPolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ClaimsMappingPolicyCollectionPage page = new ClaimsMappingPolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

