/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Application;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ApplicationCollectionPage;
import com.microsoft.graph.requests.extensions.ApplicationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ApplicationCollectionResponse;
import com.microsoft.graph.requests.extensions.ApplicationRequestBuilder;
import com.microsoft.graph.requests.extensions.IApplicationCollectionPage;
import com.microsoft.graph.requests.extensions.IApplicationCollectionRequest;
import java.util.List;

public class ApplicationCollectionRequest
extends BaseCollectionRequest<ApplicationCollectionResponse, IApplicationCollectionPage>
implements IApplicationCollectionRequest {
    public ApplicationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ApplicationCollectionResponse.class, IApplicationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IApplicationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ApplicationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IApplicationCollectionPage get() throws ClientException {
        ApplicationCollectionResponse response = (ApplicationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Application newApplication, ICallback<Application> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ApplicationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newApplication, callback);
    }

    @Override
    public Application post(Application newApplication) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ApplicationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newApplication);
    }

    @Override
    public IApplicationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IApplicationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IApplicationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IApplicationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IApplicationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IApplicationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IApplicationCollectionPage buildFromResponse(ApplicationCollectionResponse response) {
        ApplicationCollectionRequestBuilder builder = response.nextLink != null ? new ApplicationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ApplicationCollectionPage page = new ApplicationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

