/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.AppRoleAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AppRoleAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.AppRoleAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AppRoleAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.AppRoleAssignmentRequestBuilder;
import com.microsoft.graph.requests.extensions.IAppRoleAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IAppRoleAssignmentCollectionRequest;
import java.util.List;

public class AppRoleAssignmentCollectionRequest
extends BaseCollectionRequest<AppRoleAssignmentCollectionResponse, IAppRoleAssignmentCollectionPage>
implements IAppRoleAssignmentCollectionRequest {
    public AppRoleAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AppRoleAssignmentCollectionResponse.class, IAppRoleAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IAppRoleAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AppRoleAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAppRoleAssignmentCollectionPage get() throws ClientException {
        AppRoleAssignmentCollectionResponse response = (AppRoleAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(AppRoleAssignment newAppRoleAssignment, ICallback<AppRoleAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AppRoleAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAppRoleAssignment, callback);
    }

    @Override
    public AppRoleAssignment post(AppRoleAssignment newAppRoleAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AppRoleAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAppRoleAssignment);
    }

    @Override
    public IAppRoleAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IAppRoleAssignmentCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IAppRoleAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAppRoleAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IAppRoleAssignmentCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IAppRoleAssignmentCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IAppRoleAssignmentCollectionPage buildFromResponse(AppRoleAssignmentCollectionResponse response) {
        AppRoleAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new AppRoleAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AppRoleAssignmentCollectionPage page = new AppRoleAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

