/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ActivityBasedTimeoutPolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ActivityBasedTimeoutPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.ActivityBasedTimeoutPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ActivityBasedTimeoutPolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.ActivityBasedTimeoutPolicyRequestBuilder;
import com.microsoft.graph.requests.extensions.IActivityBasedTimeoutPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IActivityBasedTimeoutPolicyCollectionRequest;
import java.util.List;

public class ActivityBasedTimeoutPolicyCollectionRequest
extends BaseCollectionRequest<ActivityBasedTimeoutPolicyCollectionResponse, IActivityBasedTimeoutPolicyCollectionPage>
implements IActivityBasedTimeoutPolicyCollectionRequest {
    public ActivityBasedTimeoutPolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ActivityBasedTimeoutPolicyCollectionResponse.class, IActivityBasedTimeoutPolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IActivityBasedTimeoutPolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ActivityBasedTimeoutPolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IActivityBasedTimeoutPolicyCollectionPage get() throws ClientException {
        ActivityBasedTimeoutPolicyCollectionResponse response = (ActivityBasedTimeoutPolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ActivityBasedTimeoutPolicy newActivityBasedTimeoutPolicy, ICallback<ActivityBasedTimeoutPolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ActivityBasedTimeoutPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newActivityBasedTimeoutPolicy, callback);
    }

    @Override
    public ActivityBasedTimeoutPolicy post(ActivityBasedTimeoutPolicy newActivityBasedTimeoutPolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ActivityBasedTimeoutPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newActivityBasedTimeoutPolicy);
    }

    @Override
    public IActivityBasedTimeoutPolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IActivityBasedTimeoutPolicyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IActivityBasedTimeoutPolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IActivityBasedTimeoutPolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IActivityBasedTimeoutPolicyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IActivityBasedTimeoutPolicyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IActivityBasedTimeoutPolicyCollectionPage buildFromResponse(ActivityBasedTimeoutPolicyCollectionResponse response) {
        ActivityBasedTimeoutPolicyCollectionRequestBuilder builder = response.nextLink != null ? new ActivityBasedTimeoutPolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ActivityBasedTimeoutPolicyCollectionPage page = new ActivityBasedTimeoutPolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

