/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.concurrency;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.DefaultHttpProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.http.HttpResponseHeadersHelper;
import com.microsoft.graph.http.IConnection;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.http.IStatefulResponseHandler;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.models.extensions.UploadSession;
import com.microsoft.graph.requests.extensions.ChunkedUploadResult;
import com.microsoft.graph.serializer.ISerializer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import okhttp3.Response;

public class ChunkedUploadResponseHandler<UploadType>
implements IStatefulResponseHandler<ChunkedUploadResult<UploadType>, UploadType> {
    private static final HttpResponseHeadersHelper responseHeadersHelper = new HttpResponseHeadersHelper();
    private final Class<UploadType> deserializeTypeClass;

    public ChunkedUploadResponseHandler(Class<UploadType> uploadType) {
        this.deserializeTypeClass = uploadType;
    }

    @Override
    public void configConnection(IConnection connection) {
    }

    @Override
    public void configConnection(Response response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkedUploadResult<UploadType> generateResult(IHttpRequest request, IConnection connection, ISerializer serializer, ILogger logger) throws Exception {
        InputStream in = null;
        try {
            if (connection.getResponseCode() == 202) {
                logger.logDebug("Chunk bytes has been accepted by the server.");
                in = new BufferedInputStream(connection.getInputStream());
                UploadSession session = serializer.deserializeObject(DefaultHttpProvider.streamToString(in), UploadSession.class);
                ChunkedUploadResult chunkedUploadResult = new ChunkedUploadResult(session);
                return chunkedUploadResult;
            }
            if (connection.getResponseCode() == 201 || connection.getResponseCode() == 200) {
                logger.logDebug("Upload session is completed, uploaded item returned.");
                in = new BufferedInputStream(connection.getInputStream());
                String rawJson = DefaultHttpProvider.streamToString(in);
                UploadType uploadedItem = serializer.deserializeObject(rawJson, this.deserializeTypeClass);
                ChunkedUploadResult<UploadType> chunkedUploadResult = new ChunkedUploadResult<UploadType>(uploadedItem);
                return chunkedUploadResult;
            }
            if (connection.getResponseCode() >= 400) {
                logger.logDebug("Receiving error during upload, see detail on result error");
                ChunkedUploadResult rawJson = new ChunkedUploadResult(GraphServiceException.createFromConnection(request, null, serializer, connection, logger));
                return rawJson;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.logError(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkedUploadResult<UploadType> generateResult(IHttpRequest request, Response response, ISerializer serializer, ILogger logger) throws Exception {
        InputStream in = null;
        try {
            if (response.code() >= 400) {
                logger.logDebug("Receiving error during upload, see detail on result error");
                ChunkedUploadResult chunkedUploadResult = new ChunkedUploadResult(GraphServiceException.createFromConnection(request, null, serializer, response, logger));
                return chunkedUploadResult;
            }
            if (response.code() >= 200 && response.code() < 300) {
                Map<String, String> headers = responseHeadersHelper.getResponseHeadersAsMapStringString(response);
                String contentType = headers.get("Content-Type");
                String location = headers.get("Location");
                if (contentType != null && contentType.contains("application/json")) {
                    in = new BufferedInputStream(response.body().byteStream());
                    String rawJson = DefaultHttpProvider.streamToString(in);
                    UploadSession session = serializer.deserializeObject(rawJson, UploadSession.class);
                    if (session == null) {
                        logger.logDebug("Upload session is completed (ODSP), uploaded item returned.");
                        UploadType uploadedItem = serializer.deserializeObject(rawJson, this.deserializeTypeClass);
                        ChunkedUploadResult<UploadType> chunkedUploadResult = new ChunkedUploadResult<UploadType>(uploadedItem);
                        return chunkedUploadResult;
                    }
                    logger.logDebug("Chunk bytes has been accepted by the server.");
                    ChunkedUploadResult chunkedUploadResult = new ChunkedUploadResult(session);
                    return chunkedUploadResult;
                }
                if (location != null) {
                    logger.logDebug("Upload session is completed (Outlook), uploaded item returned.");
                    ChunkedUploadResult<UploadType> chunkedUploadResult = new ChunkedUploadResult<UploadType>(this.deserializeTypeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    return chunkedUploadResult;
                }
                logger.logDebug("Upload session returned an unexpected response");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.logError(e.getMessage(), e);
                }
            }
        }
        return new ChunkedUploadResult(new ClientException("Received an unexpected response from the service, response code: " + response.code(), null));
    }
}

