// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WindowsInformationProtectionAppLearningSummary;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Information Protection App Learning Summary Request.
 */
public class WindowsInformationProtectionAppLearningSummaryRequest extends BaseRequest implements IWindowsInformationProtectionAppLearningSummaryRequest {
	
    /**
     * The request for the WindowsInformationProtectionAppLearningSummary
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsInformationProtectionAppLearningSummaryRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsInformationProtectionAppLearningSummary.class);
    }

    /**
     * Gets the WindowsInformationProtectionAppLearningSummary from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<WindowsInformationProtectionAppLearningSummary> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WindowsInformationProtectionAppLearningSummary from the service
     *
     * @return the WindowsInformationProtectionAppLearningSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsInformationProtectionAppLearningSummary get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<WindowsInformationProtectionAppLearningSummary> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsInformationProtectionAppLearningSummary with a source
     *
     * @param sourceWindowsInformationProtectionAppLearningSummary the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final WindowsInformationProtectionAppLearningSummary sourceWindowsInformationProtectionAppLearningSummary, final ICallback<WindowsInformationProtectionAppLearningSummary> callback) {
        send(HttpMethod.PATCH, callback, sourceWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Patches this WindowsInformationProtectionAppLearningSummary with a source
     *
     * @param sourceWindowsInformationProtectionAppLearningSummary the source object with updates
     * @return the updated WindowsInformationProtectionAppLearningSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsInformationProtectionAppLearningSummary patch(final WindowsInformationProtectionAppLearningSummary sourceWindowsInformationProtectionAppLearningSummary) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Creates a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary, final ICallback<WindowsInformationProtectionAppLearningSummary> callback) {
        send(HttpMethod.POST, callback, newWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Creates a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the new object to create
     * @return the created WindowsInformationProtectionAppLearningSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsInformationProtectionAppLearningSummary post(final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary) throws ClientException {
        return send(HttpMethod.POST, newWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Creates a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary, final ICallback<WindowsInformationProtectionAppLearningSummary> callback) {
        send(HttpMethod.PUT, callback, newWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Creates a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the object to create/update
     * @return the created WindowsInformationProtectionAppLearningSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsInformationProtectionAppLearningSummary put(final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary) throws ClientException {
        return send(HttpMethod.PUT, newWindowsInformationProtectionAppLearningSummary);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IWindowsInformationProtectionAppLearningSummaryRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (WindowsInformationProtectionAppLearningSummaryRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IWindowsInformationProtectionAppLearningSummaryRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (WindowsInformationProtectionAppLearningSummaryRequest)this;
     }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
     public IWindowsInformationProtectionAppLearningSummaryRequest filter(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
         return (WindowsInformationProtectionAppLearningSummaryRequest)this;
     }

}

