// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TeamsTemplate;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.serializer.IJsonBackedObject;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams Template With Reference Request.
 */
public class TeamsTemplateWithReferenceRequest extends BaseRequest implements ITeamsTemplateWithReferenceRequest {

    /**
     * The request for the TeamsTemplate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamsTemplateWithReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsTemplate.class);
    }

    public void post(final TeamsTemplate newTeamsTemplate, final IJsonBackedObject payload, final ICallback<TeamsTemplate> callback) {
        send(HttpMethod.POST, callback, payload);
    }

    public TeamsTemplate post(final TeamsTemplate newTeamsTemplate, final IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = send(HttpMethod.POST, payload);
        if (response != null){
            return newTeamsTemplate;
        }
        return null;
    }

    public void get(final ICallback<TeamsTemplate> callback) {
        send(HttpMethod.GET, callback, null);
    }

    public TeamsTemplate get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

	public void delete(final ICallback<TeamsTemplate> callback) {
		send(HttpMethod.DELETE, callback, null);
	}

	public void delete() throws ClientException {
		send(HttpMethod.DELETE, null);
	}

	public void patch(final TeamsTemplate sourceTeamsTemplate, final ICallback<TeamsTemplate> callback) {
		send(HttpMethod.PATCH, callback, sourceTeamsTemplate);
	}

	public TeamsTemplate patch(final TeamsTemplate sourceTeamsTemplate) throws ClientException {
		return send(HttpMethod.PATCH, sourceTeamsTemplate);
	}


    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ITeamsTemplateWithReferenceRequest select(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
        return (ITeamsTemplateWithReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ITeamsTemplateWithReferenceRequest expand(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (TeamsTemplateWithReferenceRequest)this;
    }
    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    public ITeamsTemplateWithReferenceRequest filter(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
        return (TeamsTemplateWithReferenceRequest)this;
    }
}
