// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.LocalizedNotificationMessage;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Localized Notification Message Request.
 */
public class LocalizedNotificationMessageRequest extends BaseRequest implements ILocalizedNotificationMessageRequest {
	
    /**
     * The request for the LocalizedNotificationMessage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LocalizedNotificationMessageRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LocalizedNotificationMessage.class);
    }

    /**
     * Gets the LocalizedNotificationMessage from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<LocalizedNotificationMessage> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the LocalizedNotificationMessage from the service
     *
     * @return the LocalizedNotificationMessage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public LocalizedNotificationMessage get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<LocalizedNotificationMessage> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LocalizedNotificationMessage with a source
     *
     * @param sourceLocalizedNotificationMessage the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final LocalizedNotificationMessage sourceLocalizedNotificationMessage, final ICallback<LocalizedNotificationMessage> callback) {
        send(HttpMethod.PATCH, callback, sourceLocalizedNotificationMessage);
    }

    /**
     * Patches this LocalizedNotificationMessage with a source
     *
     * @param sourceLocalizedNotificationMessage the source object with updates
     * @return the updated LocalizedNotificationMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public LocalizedNotificationMessage patch(final LocalizedNotificationMessage sourceLocalizedNotificationMessage) throws ClientException {
        return send(HttpMethod.PATCH, sourceLocalizedNotificationMessage);
    }

    /**
     * Creates a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final LocalizedNotificationMessage newLocalizedNotificationMessage, final ICallback<LocalizedNotificationMessage> callback) {
        send(HttpMethod.POST, callback, newLocalizedNotificationMessage);
    }

    /**
     * Creates a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the new object to create
     * @return the created LocalizedNotificationMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public LocalizedNotificationMessage post(final LocalizedNotificationMessage newLocalizedNotificationMessage) throws ClientException {
        return send(HttpMethod.POST, newLocalizedNotificationMessage);
    }

    /**
     * Creates a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final LocalizedNotificationMessage newLocalizedNotificationMessage, final ICallback<LocalizedNotificationMessage> callback) {
        send(HttpMethod.PUT, callback, newLocalizedNotificationMessage);
    }

    /**
     * Creates a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the object to create/update
     * @return the created LocalizedNotificationMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public LocalizedNotificationMessage put(final LocalizedNotificationMessage newLocalizedNotificationMessage) throws ClientException {
        return send(HttpMethod.PUT, newLocalizedNotificationMessage);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ILocalizedNotificationMessageRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (LocalizedNotificationMessageRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ILocalizedNotificationMessageRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (LocalizedNotificationMessageRequest)this;
     }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
     public ILocalizedNotificationMessageRequest filter(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
         return (LocalizedNotificationMessageRequest)this;
     }

}

