// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookTable;
import com.microsoft.graph.requests.extensions.IWorkbookTableItemAtRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Table Item At Request.
 */
public interface IWorkbookTableItemAtRequest extends IHttpRequest {

    /**
     * Patches the WorkbookTableItemAt
     *
     * @param srcWorkbookTable the WorkbookTable with which to PATCH
     * @param callback the callback to be called after success or failure
     */
    void patch(WorkbookTable srcWorkbookTable, final ICallback<WorkbookTable> callback);

    /**
     * Patches the WorkbookTableItemAt
     *
     * @param srcWorkbookTable the WorkbookTable with which to PATCH
     * @return the WorkbookTable
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    WorkbookTable patch(WorkbookTable srcWorkbookTable) throws ClientException;

    /**
     * Puts the WorkbookTableItemAt
     *
     * @param srcWorkbookTable the WorkbookTable to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(WorkbookTable srcWorkbookTable, final ICallback<WorkbookTable> callback);

    /**
     * Puts the WorkbookTableItemAt
     *
     * @param srcWorkbookTable the WorkbookTable to PUT
     * @return the WorkbookTable
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
     WorkbookTable put(WorkbookTable srcWorkbookTable) throws ClientException;
    /**
     * Gets the WorkbookTable
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WorkbookTable> callback);

    /**
     * Gets the WorkbookTable
     *
     * @return the WorkbookTable
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    WorkbookTable get() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookTableItemAtRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookTableItemAtRequest expand(final String value);

}
