// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.PermissionGrantPolicy;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Permission Grant Policy Request.
 */
public interface IPermissionGrantPolicyRequest extends IHttpRequest {

    /**
     * Gets the PermissionGrantPolicy from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<PermissionGrantPolicy> callback);

    /**
     * Gets the PermissionGrantPolicy from the service
     *
     * @return the PermissionGrantPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PermissionGrantPolicy get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<PermissionGrantPolicy> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PermissionGrantPolicy with a source
     *
     * @param sourcePermissionGrantPolicy the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final PermissionGrantPolicy sourcePermissionGrantPolicy, final ICallback<PermissionGrantPolicy> callback);

    /**
     * Patches this PermissionGrantPolicy with a source
     *
     * @param sourcePermissionGrantPolicy the source object with updates
     * @return the updated PermissionGrantPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PermissionGrantPolicy patch(final PermissionGrantPolicy sourcePermissionGrantPolicy) throws ClientException;

    /**
     * Posts a PermissionGrantPolicy with a new object
     *
     * @param newPermissionGrantPolicy the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final PermissionGrantPolicy newPermissionGrantPolicy, final ICallback<PermissionGrantPolicy> callback);

    /**
     * Posts a PermissionGrantPolicy with a new object
     *
     * @param newPermissionGrantPolicy the new object to create
     * @return the created PermissionGrantPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PermissionGrantPolicy post(final PermissionGrantPolicy newPermissionGrantPolicy) throws ClientException;

    /**
     * Posts a PermissionGrantPolicy with a new object
     *
     * @param newPermissionGrantPolicy the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final PermissionGrantPolicy newPermissionGrantPolicy, final ICallback<PermissionGrantPolicy> callback);

    /**
     * Posts a PermissionGrantPolicy with a new object
     *
     * @param newPermissionGrantPolicy the object to create/update
     * @return the created PermissionGrantPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PermissionGrantPolicy put(final PermissionGrantPolicy newPermissionGrantPolicy) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPermissionGrantPolicyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPermissionGrantPolicyRequest expand(final String value);

}

