// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ManagedAndroidLobApp;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Managed Android Lob App Request.
 */
public interface IManagedAndroidLobAppRequest extends IHttpRequest {

    /**
     * Gets the ManagedAndroidLobApp from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<ManagedAndroidLobApp> callback);

    /**
     * Gets the ManagedAndroidLobApp from the service
     *
     * @return the ManagedAndroidLobApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedAndroidLobApp get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<ManagedAndroidLobApp> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ManagedAndroidLobApp with a source
     *
     * @param sourceManagedAndroidLobApp the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ManagedAndroidLobApp sourceManagedAndroidLobApp, final ICallback<ManagedAndroidLobApp> callback);

    /**
     * Patches this ManagedAndroidLobApp with a source
     *
     * @param sourceManagedAndroidLobApp the source object with updates
     * @return the updated ManagedAndroidLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedAndroidLobApp patch(final ManagedAndroidLobApp sourceManagedAndroidLobApp) throws ClientException;

    /**
     * Posts a ManagedAndroidLobApp with a new object
     *
     * @param newManagedAndroidLobApp the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ManagedAndroidLobApp newManagedAndroidLobApp, final ICallback<ManagedAndroidLobApp> callback);

    /**
     * Posts a ManagedAndroidLobApp with a new object
     *
     * @param newManagedAndroidLobApp the new object to create
     * @return the created ManagedAndroidLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedAndroidLobApp post(final ManagedAndroidLobApp newManagedAndroidLobApp) throws ClientException;

    /**
     * Posts a ManagedAndroidLobApp with a new object
     *
     * @param newManagedAndroidLobApp the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ManagedAndroidLobApp newManagedAndroidLobApp, final ICallback<ManagedAndroidLobApp> callback);

    /**
     * Posts a ManagedAndroidLobApp with a new object
     *
     * @param newManagedAndroidLobApp the object to create/update
     * @return the created ManagedAndroidLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedAndroidLobApp put(final ManagedAndroidLobApp newManagedAndroidLobApp) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IManagedAndroidLobAppRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IManagedAndroidLobAppRequest expand(final String value);

}

