// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.InferenceClassification;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Inference Classification Request.
 */
public interface IInferenceClassificationRequest extends IHttpRequest {

    /**
     * Gets the InferenceClassification from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<InferenceClassification> callback);

    /**
     * Gets the InferenceClassification from the service
     *
     * @return the InferenceClassification from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InferenceClassification get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<InferenceClassification> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this InferenceClassification with a source
     *
     * @param sourceInferenceClassification the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final InferenceClassification sourceInferenceClassification, final ICallback<InferenceClassification> callback);

    /**
     * Patches this InferenceClassification with a source
     *
     * @param sourceInferenceClassification the source object with updates
     * @return the updated InferenceClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InferenceClassification patch(final InferenceClassification sourceInferenceClassification) throws ClientException;

    /**
     * Posts a InferenceClassification with a new object
     *
     * @param newInferenceClassification the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final InferenceClassification newInferenceClassification, final ICallback<InferenceClassification> callback);

    /**
     * Posts a InferenceClassification with a new object
     *
     * @param newInferenceClassification the new object to create
     * @return the created InferenceClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InferenceClassification post(final InferenceClassification newInferenceClassification) throws ClientException;

    /**
     * Posts a InferenceClassification with a new object
     *
     * @param newInferenceClassification the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final InferenceClassification newInferenceClassification, final ICallback<InferenceClassification> callback);

    /**
     * Posts a InferenceClassification with a new object
     *
     * @param newInferenceClassification the object to create/update
     * @return the created InferenceClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InferenceClassification put(final InferenceClassification newInferenceClassification) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IInferenceClassificationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IInferenceClassificationRequest expand(final String value);

}

